qui {
set output error

noi {
	/**********************************************************************/
	/****** Step 2.2. Simulate counterfactuals - robustness check 3 *******/
	/**********************************************************************/
}
			
			* Load & prepare spatial data
			cd ..
			cd "./2. Raw data"
			use GeoDist.dta, clear
			keep iso_o iso_d dist distcap
			
			* Collect bilateral distances between capitals
			drop dist
			reshape wide distcap, i(iso_o) j(iso_d) string

			levelsof iso_o, local(cntries)

			foreach i in `cntries' {
				gen geographical_sample_`i' = 0
				replace geographical_sample_`i' = 1 if distcap`i' >= $spatial_constraint_2
				sum geographical_sample_`i' if geographical_sample_`i' == 1
				drop distcap`i'
				}
				
			* Rename variables
			duplicates drop iso_o, force
			rename iso_o cntrycode_ISO
			
			* Add data on missing countries, use data on most nearby country

				* East Timor = Indonesia
				expand 2 if cntrycode_ISO == "IND", gen(expanded)
				replace cntrycode_ISO = "74" if expanded == 1
				gen geographical_sample_74 = geographical_sample_IND
				drop expanded
				
				* Liechtenstein = Switzerland
				expand 2 if cntrycode_ISO == "SWZ", gen(expanded)
				replace cntrycode_ISO = "161" if expanded == 1
				gen geographical_sample_161 = geographical_sample_SWZ
				drop expanded
				
				* Monaco = France
				expand 2 if cntrycode_ISO == "FRA", gen(expanded)
				replace cntrycode_ISO = "185" if expanded == 1
				gen geographical_sample_185 = geographical_sample_FRA
				drop expanded
				
				* Montenegro = Albania
				expand 2 if cntrycode_ISO == "ALB", gen(expanded)
				replace cntrycode_ISO = "187" if expanded == 1
				gen geographical_sample_187 = geographical_sample_ALB
				drop expanded
				
				* South Korea = Korea
				expand 2 if cntrycode_ISO == "KOR", gen(expanded)
				replace cntrycode_ISO = "259" if expanded == 1
				gen geographical_sample_259 = geographical_sample_KOR
				drop expanded
				
				* Suriname = Guyana
				expand 2 if cntrycode_ISO == "GUY", gen(expanded)
				replace cntrycode_ISO = "268" if expanded == 1
				gen geographical_sample_268 = geographical_sample_GUY
				drop expanded
				
				* Serbia = Croatia
				expand 2 if cntrycode_ISO == "HRV", gen(expanded)
				replace cntrycode_ISO = "317" if expanded == 1
				gen geographical_sample_317 = geographical_sample_HRV
				drop expanded
				
			* Add country identifiers
			cd ..
			cd ".\3. Intermediary results"
			merge m:1 cntrycode_ISO using setup, keepusing(cntry)
			drop if _merge == 1
			drop _merge
			drop if geographical_sample_ABW == .
			order cntry cntrycode_ISO 
			save geographical_samples, replace

			* Load starting data
			cd ..
			cd ".\3. Intermediary results"
			use starting_data, clear
			
			* Add bilateral intercapital distances
			merge m:1 cntry using geographical_samples
			drop if _merge == 2
			drop _merge

			use starting_data, clear
			
			* Add bilateral intercapital distances
			merge m:1 cntry using geographical_samples
			drop if _merge == 2
			drop _merge
			
			* Indicate countrycodes corresponding to each geographically restricted set of control countries & exclude irrelevant (former) countries
			levelsof cntrycode_ISO, local(cntries)
			foreach cntry in `cntries' {
				sum cntrycode if cntrycode_ISO == "`cntry'"
				cap rename geographical_sample_`cntry' geographical_sample_`r(mean)'
				cap replace geographical_sample_`r(mean)' = 0 if geographical_sample_`r(mean)' == . & cntrycode < 500
				}
			
			keep cntry cntrycode year geographical_*
			save geographical_samples_3, replace

			* 6.2.3. Run algorithm
			local count = 0
			foreach NIC in $NICs {
			
				local count = `count'+1
				noisily di "Synthetic control method: newly independent cntry `count'/$max [" c(current_date) " : " c(current_time) "]:"
					
				* Clean data (remove incomplete simulations)
				cd ".\3.1. Simulated gaps\3.1.1.3. Robustness check 3\3.1.1.1. Weights"
				cap confirm file cntry_weights1_`NIC'.dta
				if _rc != 0 {
					cd .. 
					cd ..
					cd ..
					cd ".\3.2. Individual pseudo-gaps\3.2.3. Robustness check 3\3.2.2. Intermediaries"
					capture erase placebo1_`NIC'.dta
					}
				cd ..
				cd ..
				cd ..
					
				* Check which cases still needed to be simulated
				cd ".\3.2. Individual pseudo-gaps\3.2.3. Robustness check 3\3.2.2. Intermediaries"
				capture confirm file placebo1_`NIC'.dta
				cd ..
				cd ..
				cd ..
				if _rc != 0 {
					
					local included = 0
					cd ".\3.4. Intermediaries"
					
						local identifier = "_10_"
						use data_10_`NIC', clear
						
						* Collect bilateral distances between capitals
						cd ..
						merge 1:1 cntrycode year using geographical_samples_3
						drop if _merge != 3
						drop _merge
						
						* Drop countries outside geographic constraint
						cap drop if geographical_sample_`NIC' == 0 & cntrycode != `NIC'
						if _rc == 0 {
							local included = 1
							}							
					if `included' == 1 {

						cd ..
						
						* Gather MSPE info
						preserve 
						keep earliest_* last_* preind* independence_year
						ds
						restore
						
						foreach input in `r(varlist)' {
							sum `input'
							local `input' = `r(mean)'
							}
							
						* Check data availability of covariates
						global SCM_covariates_1
						foreach var in $SCM_covariates {
							if "`var'" != "baseline_gdpcap" {
							cap sum earliest_year_`var'
								if _rc == 0 {
									if `earliest_year_`var'' <= `preindependence_year_1' {
										global SCM_covariates_1 $SCM_covariates_1 `var'(`earliest_year_`var''/`preindependence_year_1')
										}
									}
								}
							}
							
						* Perform simulation for this NIC
						cap noi synth baseline_gdpcap baseline_gdpcap(`earliest_year_baseline_gdpcap'(1)`preindependence_year_1') $SCM_covariates_1 , mspeperiod(`earliest_year_baseline_gdpcap'/`preindependence_year_1') resultsperiod(`earliest_year'/`last_year') trunit(`NIC') trperiod(`independence_year') nested allopt
						if _rc != 0 {
							*If no convergence is reached: apply the second-most accurate (nested) approach
							cap synth baseline_gdpcap baseline_gdpcap(`earliest_year_baseline_gdpcap'(1)`preindependence_year_1') $SCM_covariates_1 , mspeperiod(`earliest_year_baseline_gdpcap'/`preindependence_year_1') resultsperiod(`earliest_year'/`last_year') trunit(`NIC') trperiod(`independence_year') nested
							if _rc != 0 {
								*If no convergence is reached: use the third-most accurate (regression-based) approach
								cap synth baseline_gdpcap baseline_gdpcap(`earliest_year_baseline_gdpcap'(1)`preindependence_year_1') $SCM_covariates_1 , mspeperiod(`earliest_year_baseline_gdpcap'/`preindependence_year_1') resultsperiod(`earliest_year'/`last_year') trunit(`NIC') trperiod(`independence_year')
								}
							}
						else if _rc == 0 {
							matrix cntry_weights = e(W_weights)
							local check_weights = cntry_weights[1,2]
							if `check_weights' == . {
								noi di "missing weights, re-estimate"
									cap synth baseline_gdpcap baseline_gdpcap(`earliest_year_baseline_gdpcap'(1)`preindependence_year_1') $SCM_covariates_1 , mspeperiod(`earliest_year_baseline_gdpcap'/`preindependence_year_1') resultsperiod(`earliest_year'/`last_year') trunit(`NIC') trperiod(`independence_year') nested
									}
								}
										
						* Save results matrices
										
							* weights
							matrix cntry_weights1_`NIC' = e(W_weights)
							matsave cntry_weights1_`NIC', replace p(".\3. Intermediary results\3.1. Simulated gaps\3.1.1.3. robustness check 3\3.1.1.1. Weights") saving
							
							* balance
							matrix balance1_`NIC' =  e(X_balance)
							matsave balance1_`NIC', replace  p(".\3. Intermediary results\3.1. Simulated gaps\3.1.1.3. robustness check 3\3.1.1.2. Balance") saving
										
						* Perform placebo-simulations for control group
						scalar numberofcontrols = rowsof(cntry_weights1_`NIC')
						local numberofcontrols = numberofcontrols
						global looprange = `numberofcontrols'
						noisily di "# Placebo gaps to estimate = `numberofcontrols'", _continue
						
						* Parallel simulation procedure
						
							* Clean data (remove incomplete simulations)

							cd ".\3. Intermediary results\3.2. Individual pseudo-gaps\3.2.3. robustness check 3\3.2.2. Intermediaries"
							forval j= 1 /`numberofcontrols' {

								* Check whether the simulation was initiated
								capture confirm file controle1_`NIC'_`j'.dta
								if _rc == 0 {	
									
									* If so: check whether it was finished
									cd ..
									cd ".\3.2.1. Weights"
									capture confirm file cntry_weights1_`NIC'_`j'.dta
									if _rc != 0 {	
										
										cd ..
										cd ".\3.2.2. Intermediaries"
										* If not: remove indicator and loop over it again
										erase controle1_`NIC'_`j'.dta
										}
										
									}
									
								}
							cd ..
							cd ..
							cd ..
							cd ..
							
							* Save data for usage in parallel computation procedure
							cd "./3. Intermediary results"
							gen str identifier = "`identifier'"
							gen specification = 1
							gen NIC = `NIC'
							gen looprange = `numberofcontrols'
							save data, replace
							clear all
							
							* Run computations						
							cd ..
							cd ".\1. Dofiles"
							parallel setclusters $numberofclusters, force
							noi parallel do "2.2.h. Parallel loop.do", nodata
							noisily di ": done"
							noisily di ""
							
							* Erase unnecessary information
							cd ..
							cd "./3. Intermediary results"
							use data, clear
							erase data.dta
													
							* Indicate everything is estimated
							cd ".\3.2. Individual pseudo-gaps\3.2.3. robustness check 3\3.2.1. Weights"
							cap confirm file cntry_weights1_`NIC'_`numberofcontrols'.dta
							if _rc == 0 {
								cd ..
								cd ".\3.2.2. Intermediaries"
								gen n = _n
								keep if n == 1
								keep n
								save placebo1_`NIC', replace
								cd ..
								cd ..
								cd ..
								}
							else if _rc != 0 {
								cd ..
								cd ..
								cd ..
								}
							}
						}
					}
		
* Reroute to directory containing dofiles
cd ..
cd ".\1. Dofiles"
}
